<div>
    <p><strong>Nombre Caja:</strong> {{ $caja->nombre }}</p>
    <p><strong>Saldo Final:</strong> S/ {{ number_format($caja->saldo_final, 2) }}</p>

    <table id="tablaSemestres" class="table table-sm table-striped mt-3">
        <thead>
            <tr>
                <th>#</th>
                <th>Tipo</th>
                <th>Monto</th>
                <th>Fecha</th>
                <th>Concepto</th>
                <th>Observación</th>
            </tr>
        </thead>
        <tbody>
            @forelse($transacciones as $t)
                <tr>
                    <td>{{ $loop->iteration }}</td>
                    <td>{{ ucfirst($t->tipo) }}</td>
                    <td>S/ {{ number_format($t->monto, 2) }}</td>
                    <td>{{ \Carbon\Carbon::parse($t->fecha)->format('d/m/Y') }}</td>
                    <td>{{ $t->concepto->nombre ?? '-' }}</td>
                    <td>{{ $t->observacion }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="6" class="text-center">Sin transacciones</td>
                </tr>
            @endforelse
        </tbody>
    </table>
</div>
