@extends('layouts.master')
@section('title') Inicio @endsection
@section('content')
<!-- this is breadcrumbs -->
@component('components.breadcrumb')
@slot('li_1') Inicio @endslot
@slot('li_2') Panel Academico @endslot
@slot('title') Ver Horario de Docente @endslot
@endcomponent

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                

                @if ($horarios->isEmpty())
                <div class="alert alert-info">No hay horarios registrados para el periodo actual.</div>
                @else
                    <div class="table-responsive">
                        <table class="table table-bordered text-center align-middle">
                            <thead class="table-light">
                                <tr>
                                    <th>Hora</th>
                                    @foreach (['Lunes','Martes','Miércoles','Jueves','Viernes','Sábado'] as $dia)
                                        <th>{{ $dia }}</th>
                                    @endforeach
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $bloques = [];
                                    foreach ($horarios as $horario) {
                                        $inicio = \Carbon\Carbon::createFromTimeString($horario->hora_inicio);
                                        $fin = \Carbon\Carbon::createFromTimeString($horario->hora_fin);

                                        while ($inicio < $fin) {
                                            $slot_inicio = $inicio->format('H:i');
                                            $slot_fin = $inicio->copy()->addMinutes(45)->format('H:i');

                                            $bloques[$slot_inicio][$horario->dia] = [
                                                'curso' => $horario->curso->nombre ?? '',
                                                'aula' => $horario->numero_aula ?? '',
                                                'seccion' => $horario->seccion->nombre ?? '',
                                            ];

                                            $inicio->addMinutes(45);
                                        }
                                    }

                                    ksort($bloques);
                                @endphp

                                @foreach ($bloques as $hora => $dias)
                                    @php
                                        $fin_hora = \Carbon\Carbon::createFromTimeString($hora)->addMinutes(45)->format('H:i');
                                    @endphp
                                    <tr>
                                        <td>{{ $hora }} - {{ $fin_hora }}</td>
                                        @foreach (['Lunes','Martes','Miércoles','Jueves','Viernes','Sábado'] as $dia)
                                            <td>
                                                @if (isset($dias[$dia]))
                                                    <strong>{{ $dias[$dia]['curso'] }}</strong><br>
                                                    Aula: {{ $dias[$dia]['aula'] }}<br>
                                                    Sección: {{ $dias[$dia]['seccion'] }}
                                                @else
                                                    —
                                                @endif
                                            </td>
                                        @endforeach
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @endif
        
                
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>







<!--end row-->


@endsection
@section('script')
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    document.getElementById('formPerfil').addEventListener('submit', function(e) {
        e.preventDefault();

        let form = this;
        let formData = new FormData(form);

        fetch("{{ route('docente.actualizar-perfil') }}", {
            method: "POST",
            headers: {
                'X-CSRF-TOKEN': document.querySelector('input[name="_token"]').value
            },
            body: formData
        })
        .then(response => {
            if (!response.ok) throw response;
            return response.json();
        })
        .then(data => {
            Swal.fire({
                icon: 'success',
                title: 'Perfil actualizado',
                text: data.message || 'Perfil actualizado correctamente',
                confirmButtonText: 'Aceptar'
            }).then(() => {
                location.reload();
            });
        })
        .catch(async error => {
            let msg = 'Ocurrió un error al guardar';

            if (error.status === 422) {
                const err = await error.json();
                msg = Object.values(err.errors).flat().join('\n');
            }

            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: msg
            });
        });
    });
</script>







@endsection
