@extends('layouts.master')
@section('title') Inicio @endsection
@section('content')
<!-- this is breadcrumbs -->
@component('components.breadcrumb')
@slot('li_1') Inicio @endslot
@slot('li_2') Panel Academico @endslot
@slot('title') Periodos @endslot
@endcomponent

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                
                
                    <form id="filtroForm" class="row g-3 mb-3">
                        <div class="col-md-4">
                            <label>Desde:</label>
                            <input type="date" name="desde" class="form-control">
                        </div>
                        <div class="col-md-4">
                            <label>Hasta:</label>
                            <input type="date" name="hasta" class="form-control">
                        </div>
                        <div class="col-md-4">
                            <label>Plan de estudio:</label>
                            <select name="id_plan_estudio" class="form-select">
                                <option value="">Todos</option>
                                @foreach ($planes as $plan)
                                    <option value="{{ $plan->id }}">{{ $plan->nombre }}</option>
                                @endforeach
                            </select>
                        </div>
                    </form>

                    <div id="tablaResultados" class="table-responsive"></div>

                
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>






<!--end row-->


@endsection
@section('script')
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
document.addEventListener('DOMContentLoaded', () => {
    const form = document.getElementById('filtroForm');

    form.addEventListener('change', () => {
        const params = new URLSearchParams(new FormData(form)).toString();
        fetch(`{{ route('ofertas.reporte.ajax') }}?${params}`)
            .then(res => res.text())
            .then(html => {
                const contenedor = document.getElementById('tablaResultados');
                contenedor.innerHTML = html;

                // Esperar un momento para que el DOM se actualice con la tabla nueva
                setTimeout(() => {
                    const tabla = $('#tablaPeriodos');

                    // Si ya existe una instancia de DataTable, destruirla antes de crear una nueva
                    if ($.fn.DataTable.isDataTable(tabla)) {
                        tabla.DataTable().clear().destroy();
                    }

                    // Inicializar DataTable con configuración y botones
                    tabla.DataTable({
                        responsive: true,
                        lengthChange: true,
                        autoWidth: false,
                        paging: true,
                        searching: true,
                        info: true,
                        buttons: [
                            {
                                extend: 'collection',
                                text: 'Opciones',
                                buttons: [
                                    { extend: 'copy', text: 'Copiar' },
                                    { extend: 'csv', text: 'CSV' },
                                    { extend: 'excel', text: 'Excel', title: 'Ofertas Laborales' },
                                    { extend: 'pdf', text: 'PDF' },
                                    { extend: 'print', text: 'Imprimir' }
                                ]
                            },
                            { extend: 'colvis', text: 'Columnas' }
                        ],
                        language: {
                            search: "Buscar:",
                            lengthMenu: "Mostrar _MENU_ registros por página",
                            info: "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                            paginate: {
                                first: "Primero",
                                previous: "Anterior",
                                next: "Siguiente",
                                last: "Último"
                            }
                        }
                    })
                    .buttons().container().appendTo('#tablaPeriodos_wrapper .col-md-6:eq(0)');
                }, 50);
            });
    });

    // Disparar al inicio para mostrar resultados por defecto
    form.dispatchEvent(new Event('change'));
});
</script>




@endsection
