@php
    use App\Models\Instituto;
    $instituto = Instituto::first();
@endphp

<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Ficha de Matrícula</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            padding: 20px;
            font-family: Arial, sans-serif;
            font-size: 0.85rem;
        }

        .header {
            text-align: center;
            margin-bottom: 10px;
        }

        .header h3 {
            font-size: 1.4rem;
            margin-top: 10px;
        }

        .info-table td {
            padding: 8px;
            vertical-align: middle;
        }

        .info-table {
            margin-top: 20px;
            width: 100%;
        }

        .table-container {
            margin-top: 30px;
            width: 100%;
            overflow-x: auto;
        }

        .notes-table {
            width: 100%;
            border-collapse: collapse;
            table-layout: fixed;
            word-wrap: break-word;
            font-size: 0.75rem;
        }

        .notes-table th,
        .notes-table td {
            border: 1px solid #dee2e6;
            text-align: center;
            padding: 6px;
        }

        .notes-table th {
            background-color: #f8f9fa;
            font-weight: bold;
        }

        .table-striped tbody tr:nth-of-type(odd) {
            background-color: #f2f2f2;
        }

        .logo-img {
            max-height: 80px;
        }
    </style>
</head>
<body>
    <div class="header">
        <img src="{{ public_path('storage/' . $instituto->logo) }}" class="logo-img">
    </div>

    <div class="header">
        <h2>Ficha de Matrícula</h2>
    </div>

    <table class="table table-bordered info-table">
        <tbody>
            <tr>
                <td><strong>Institución</strong></td>
                <td>{{ $instituto->nombre }}</td>
                <td><strong>DRE</strong></td>
                <td>{{ $instituto->dre }}</td>
            </tr>
            <tr>
                <td><strong>Dirección</strong></td>
                <td>{{ $instituto->direccion }}</td>
                <td><strong>Teléfono</strong></td>
                <td>{{ $instituto->telefono }}</td>
            </tr>
            <tr>
                <td><strong>Código Modular</strong></td>
                <td>{{ $instituto->codigo_modular }}</td>
                <td><strong>Departamento</strong></td>
                <td>{{ $instituto->departamento }}</td>
            </tr>
            <tr>
                <td><strong>Provincia</strong></td>
                <td>{{ $instituto->provincia }}</td>
                <td><strong>Distrito</strong></td>
                <td>{{ $instituto->distrito }}</td>
            </tr>
        </tbody>
    </table>

    
    <table class="table table-bordered info-table">
        <tbody>
            <tr>
                <td><strong>Apellidos y Nombres</strong></td>
                <td>{{ $matricula->postulante->apellidos }} {{ $matricula->postulante->nombres }}</td>
                <td><strong>DNI</strong></td>
                <td>{{ $matricula->postulante->dni }}</td>
            </tr>
            <tr>
                <td><strong>Periodo</strong></td>
                <td>{{ $matricula->periodo->nombre }}</td>
                <td><strong>Plan de Estudios</strong></td>
                <td>{{ $matricula->planEstudio->nombre }}</td>
            </tr>
            <tr>
                <td><strong>Semestre</strong></td>
                <td>{{ $matricula->semestre->nombre }}</td>
                <td><strong>Estado</strong></td>
                <td>{{ $matricula->estado }}</td>
            </tr>
        </tbody>
    </table>

    
    <div class="table-container">
        <table class="table table-bordered table-striped notes-table">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Curso</th>
                    <th>Horas Semestrales</th>
                    <th>Horas Prácticas</th>
                    <th>Créditos</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($matricula->matriculaCursos as $index => $mc)
                    <tr>
                        <td>{{ $index + 1 }}</td>
                        <td>{{ $mc->curso->nombre ?? '---' }}</td>
                        <td>{{ $mc->curso->horas_semestrales ?? '-' }}</td>
                        <td>{{ $mc->estado }}</td>
                        <td>{{ $mc->curso->creditos ?? '-' }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>

    <p class="text-end mt-4"><strong>Fecha de emisión:</strong> {{ now()->format('d/m/Y') }}</p>

</body>
</html>
