<?php $__env->startSection('title'); ?> Inicio <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- this is breadcrumbs -->
<?php $__env->startComponent('components.breadcrumb'); ?>
<?php $__env->slot('li_1'); ?> Inicio <?php $__env->endSlot(); ?>
<?php $__env->slot('li_2'); ?> Panel Academico <?php $__env->endSlot(); ?>
<?php $__env->slot('title'); ?> Unidades Didacticas <?php $__env->endSlot(); ?>
<?php echo $__env->renderComponent(); ?>

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
            
                
                <form id="form-curso" method="POST">
    <?php echo csrf_field(); ?>

    
    <div class="card shadow-sm mb-4 border-start border-4 border-primary">
        <div class="card-body">

            <h6 class="text-primary fw-semibold mb-3">
                <i class="fas fa-sitemap me-1"></i> Contexto Curricular
            </h6>

            <div class="row g-3 align-items-end">
                <div class="col-md-6">
                    <label class="form-label fw-semibold">Plan de Estudio</label>
                    <select name="planes_estudio[]" id="planes_estudio" class="form-select" required>
                        <option value="">Seleccione un plan</option>
                        <?php $__currentLoopData = $planesEstudio; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($plan->id); ?>"><?php echo e($plan->nombre); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <small class="text-muted">
                        Define la categoría del curso en Moodle
                    </small>
                </div>

                <div class="col-md-6">
                    <label class="form-label fw-semibold">Módulo Formativo</label>
                    <select name="id_modulo" id="id_modulo" class="form-select" disabled required>
                        <option value="">Seleccione un plan primero</option>
                    </select>
                </div>
            </div>

        </div>
    </div>

    
    <div class="card shadow-sm mb-4 border-start border-4 border-success">
        <div class="card-body">

            <h6 class="text-success fw-semibold mb-3">
                <i class="fas fa-book me-1"></i> Datos del Curso
            </h6>

            <div class="row g-3">
                <div class="col-md-6">
                    <label class="form-label">Nombre del Curso</label>
                    <input type="text" name="nombre" class="form-control" required>
                </div>

                <div class="col-md-6">
                    <label class="form-label">Tipo</label>
                    <select name="tipo" class="form-select" required>
                        <option value="">Seleccione</option>
                        <option value="Especialidad">Especialidad</option>
                        <option value="Transversal">Transversal</option>
                    </select>
                </div>

                <div class="col-12">
                    <label class="form-label">Descripción</label>
                    <textarea name="descripcion" class="form-control" rows="2"></textarea>
                </div>
            </div>

        </div>
    </div>

    
    <div class="card shadow-sm mb-4 border-start border-4 border-warning">
        <div class="card-body">

            <h6 class="text-warning fw-semibold mb-3">
                <i class="fas fa-clock me-1"></i> Carga Académica
            </h6>

            <div class="row g-3">
                <div class="col-md-3">
                    <label class="form-label">Créditos</label>
                    <input type="number" name="creditos" class="form-control">
                </div>

                <div class="col-md-3">
                    <label class="form-label">Horas Semestrales</label>
                    <input type="number" name="horas_semestrales" class="form-control">
                </div>

                <div class="col-md-3">
                    <label class="form-label">Semestre</label>
                    <select name="semestre_id" class="form-select" required>
                        <option value="">Seleccione</option>
                        <?php $__currentLoopData = $semestres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $semestre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($semestre->id); ?>"><?php echo e($semestre->nombre); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <div class="col-md-3">
                    <label class="form-label">Orden</label>
                    <input type="number" name="orden" class="form-control">
                </div>
            </div>

        </div>
    </div>

    
    <div class="d-flex justify-content-end gap-2">
        <a href="<?php echo e(route('cursos.index')); ?>" class="btn btn-sm btn-light border">
            Cancelar
        </a>
        <button type="submit" class="btn btn-sm btn-primary">
            Guardar
        </button>
    </div>

</form>


            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>







<!--end row-->


<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>



<script>
document.addEventListener('DOMContentLoaded', function () {

    const form = document.getElementById('form-curso');
    const planSelect = document.getElementById('planes_estudio');
    const moduloSelect = document.getElementById('id_modulo');

    // ===============================
    // Cargar módulos según plan
    // ===============================
    planSelect.addEventListener('change', function () {

        const planId = this.value;

        // Reset módulo
        moduloSelect.innerHTML = '<option value="">Seleccione un plan primero</option>';
        moduloSelect.disabled = true;

        if (!planId) return;

        // Estado cargando
        moduloSelect.innerHTML = '<option value="">Cargando módulos...</option>';

        fetch(`/modulos-por-plan/${planId}`)
            .then(response => {
                if (!response.ok) throw new Error('Error en la respuesta');
                return response.json();
            })
            .then(data => {

                moduloSelect.innerHTML = '<option value="">Seleccione módulo</option>';

                if (data.length === 0) {
                    moduloSelect.innerHTML = '<option value="">No hay módulos disponibles</option>';
                    return;
                }

                data.forEach(modulo => {
                    const option = document.createElement('option');
                    option.value = modulo.id_modulo;
                    option.textContent = modulo.nombre;
                    moduloSelect.appendChild(option);
                });

                moduloSelect.disabled = false;
            })
            .catch(error => {
                console.error('Error al cargar módulos:', error);
                moduloSelect.innerHTML = '<option value="">Error al cargar módulos</option>';
            });
    });

    // ===============================
    // Enviar formulario con AJAX
    // ===============================
    form.addEventListener('submit', function (e) {
        e.preventDefault();

        const formData = new FormData(form);

        fetch("<?php echo e(route('cursos.store')); ?>", {
            method: 'POST',
            body: formData,
            headers: {
                'Accept': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {

            if (data.success) {
                Swal.fire({
                    icon: 'success',
                    title: 'Curso registrado',
                    text: data.message,
                    confirmButtonText: 'Aceptar'
                }).then(() => {
                    window.location.href = "<?php echo e(route('cursos.index')); ?>";
                });
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: data.message || 'No se pudo registrar el curso',
                    confirmButtonText: 'Reintentar'
                });
            }

        })
        .catch(error => {
            console.error(error);
            Swal.fire({
                icon: 'error',
                title: 'Error inesperado',
                text: 'Hubo un problema al guardar el curso.',
                confirmButtonText: 'Reintentar'
            });
        });
    });

});
</script>





<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\SISTEMAS\academico-master\resources\views/cursos/create.blade.php ENDPATH**/ ?>