<?php $__env->startSection('title'); ?> Inicio <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- this is breadcrumbs -->
<?php $__env->startComponent('components.breadcrumb'); ?>
<?php $__env->slot('li_1'); ?> Inicio <?php $__env->endSlot(); ?>
<?php $__env->slot('li_2'); ?> Panel Administrativo <?php $__env->endSlot(); ?>
<?php $__env->slot('title'); ?> Convalidaciones <?php $__env->endSlot(); ?>
<?php echo $__env->renderComponent(); ?>

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">

            <!-- Buscar por DNI -->
            <div class="card p-3 mb-3">
                <div class="row g-2 align-items-end">
                    <div class="col-md-4">
                        <label for="dni">DNI del estudiante</label>
                        <input type="text" id="dni" class="form-control" placeholder="Ingrese DNI">
                    </div>
                    <div class="col-md-2">
                        <button id="btnBuscar" class="btn btn-primary">Buscar</button>
                    </div>
                </div>
            </div>

                <!-- Resultados -->
                <div id="infoEstudiante" style="display: none;">
                    <h5>Datos del Estudiante</h5>
                    <p><strong>Nombre:</strong> <span id="nombreEstudiante"></span></p>
                    <p><strong>Plan de Estudios:</strong> <span id="planEstudio"></span></p>
                    <p><strong>Semestre:</strong> <span id="semestre"></span></p>
                    <p><strong>Periodo:</strong> <span id="periodo"></span></p>

                </div>
                
                <div class="table-responsive">
                    
                    <h5 class="mt-3">Cursos Matriculados</h5>
                    <div class="table-responsive">
                        <table class="table table-striped mb-0 table-hover">
                            <thead class="thead-light">
                                <tr>
                                    <th>Curso</th>
                                    <th>Estado</th>
                                    <th>Acciones</th>
                                </tr>
                            </thead>
                            <tbody id="tablaCursos">
                                <!-- Cursos se cargarán vía JS -->
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>






<!--end row-->
<div class="modal fade" id="modalConvalidacion" tabindex="-1" aria-labelledby="modalConvalidacionLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <form id="formConvalidacion">
      <?php echo csrf_field(); ?>
      <div class="modal-content">
        <div class="modal-header bg-primary text-white">
          <h5 class="modal-title" id="modalConvalidacionLabel">Registrar Convalidación</h5>
          <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Cerrar"></button>
        </div>

        <div class="modal-body">
          
          <input type="hidden" name="estudiante_id" id="estudiante_id">
          <input type="hidden" name="curso_destino_id" id="curso_destino_id">
          <input type="hidden" name="periodo_id" id="periodo_id">

          <div class="row g-3">
            <div class="col-md-6">
              <label class="form-label">Curso Origen <span class="text-danger">*</span></label>
              <input type="text" class="form-control" name="curso_origen" placeholder="Ej: Cálculo I" required>
            </div>

            <div class="col-md-6">
              <label class="form-label">Institución Origen <span class="text-danger">*</span></label>
              <input type="text" class="form-control" name="institucion_origen" placeholder="Ej: Universidad XYZ" required>
            </div>

            <div class="col-md-4">
              <label class="form-label">Nota Origen <span class="text-danger">*</span></label>
              <input type="number" step="0.01" min="0" max="20" class="form-control" name="nota_origen" placeholder="Ej: 15.5" required>
            </div>

            <div class="col-md-4">
              <label class="form-label">Fecha de Convalidación <span class="text-danger">*</span></label>
              <input type="date" class="form-control" name="fecha_convalidacion" required>
            </div>

            <div class="col-md-12">
              <label class="form-label">Observaciones</label>
              <textarea class="form-control" name="observaciones" rows="3" placeholder="Opcional"></textarea>
            </div>
          </div>
        </div>

        <div class="modal-footer">
          <button type="submit" class="btn btn-success">
            <i class="mdi mdi-content-save"></i> Guardar Convalidación
          </button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
        </div>
      </div>
    </form>
  </div>
</div>


<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    $(document).ready(function () {
        $("#tablaModulos").DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": false,
            "buttons": [
                {
                    extend: 'collection',
                    text: 'Opciones',
                    buttons: [
                        { extend: 'copy', text: 'Copiar' },
                        { extend: 'csv', text: 'CSV' },
                        { extend: 'excel', text: 'Excel', title: 'Periodos Académicos' },
                        { extend: 'pdf', text: 'PDF' },
                        { extend: 'print', text: 'Imprimir' }
                    ]
                },
                { extend: 'colvis', text: 'Visibilidad de Columna' }
            ],
            "paging": true,
            "searching": true,
            "info": true,
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ registros por página",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "first": "Primero",
                    "previous": "Anterior",
                    "next": "Siguiente",
                    "last": "Último"
                }
            }
        }).buttons().container().appendTo('#tablaModulos_wrapper .col-md-6:eq(0)');
    });
</script>

<script>
    $(document).ready(function () {
        $('#btnBuscar').click(function () {
            const dni = $('#dni').val().trim();

            if (!dni) {
                Swal.fire('Advertencia', 'Ingrese un DNI', 'warning');
                return;
            }

            $.ajax({
                url: "<?php echo e(route('convalidaciones.buscar')); ?>",
                type: "POST",
                data: {
                    _token: "<?php echo e(csrf_token()); ?>",
                    dni: dni
                },
                success: function (data) {
                    // Mostrar la sección
                    $('#infoEstudiante').show();

                    // Rellenar información
                    $('#nombreEstudiante').text(data.postulante.nombres + ' ' + data.postulante.apellidos);
                    $('#planEstudio').text(data.matricula.plan_estudio.nombre);
                    $('#semestre').text(data.matricula.semestre.nombre);
                    $('#periodo').text(data.periodo.nombre);

                    // Guardar IDs ocultos
                    $('#estudiante_id').val(data.postulante.id_postulante);
                    $('#periodo_id').val(data.periodo.id);

                    // Construir tabla de cursos
                    let html = '';
                    data.cursos.forEach(function (item) {
                        html += `
                            <tr>
                                <td>${item.curso.nombre}</td>
                                <td>${item.estado}</td>
                                <td>
                                    <button class="btn btn-sm btn-primary" onclick="abrirModal(${item.curso.id}, '${item.curso.nombre}')">
                                        Convalidar
                                    </button>
                                </td>
                            </tr>`;
                    });
                    $('#tablaCursos').html(html);
                },
                error: function (xhr) {
                    if (xhr.status === 404 && xhr.responseJSON?.error) {
                        Swal.fire('No encontrado', xhr.responseJSON.error, 'error');
                    } else {
                        Swal.fire('Error', 'Ocurrió un error al buscar el estudiante.', 'error');
                    }

                    $('#infoEstudiante').hide();
                    $('#tablaCursos').html('');
                }
            });
        });
    });
</script>
<script>
    function abrirModal(cursoId, cursoNombre) {
        $('#curso_destino_id').val(cursoId); // ✅ correcto id del input

        $('#modalConvalidacionLabel').text('Registrar Convalidación para: ' + cursoNombre);
        $('#formConvalidacion')[0].reset(); // Limpia campos anteriores
        $('#modalConvalidacion').modal('show');
    }
</script>


<script>
$(document).ready(function () {
    $('#formConvalidacion').on('submit', function (e) {
        e.preventDefault();

        const formData = $(this).serialize();

        $.ajax({
            url: "<?php echo e(route('convalidaciones.store')); ?>",
            type: "POST",
            data: formData,
            success: function (response) {
                Swal.fire({
                    icon: 'success',
                    title: 'Éxito',
                    text: response.message
                });

                $('#modalConvalidacion').modal('hide');
                $('#formConvalidacion')[0].reset();
            },
            error: function (xhr) {
                if (xhr.status === 422) {
                    let errores = '';
                    Object.values(xhr.responseJSON.errors).forEach(error => {
                        errores += `• ${error}<br>`;
                    });

                    Swal.fire({
                        icon: 'error',
                        title: 'Errores de validación',
                        html: errores
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'Ocurrió un problema al registrar la convalidación.'
                    });
                }
            }
        });
    });
});
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\SISTEMAS\academico-master\resources\views/convalidaciones/index.blade.php ENDPATH**/ ?>